///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
// Include Guard
#ifndef __ICEINSTRUMENTTRACE_H__
#define __ICEINSTRUMENTTRACE_H__

	class InstrumentTrace
	{
	#ifndef NO_INSTRUMENTATION
		private:
			bool	dataLinked;
			void*	data;

			void	LinkData();

			// Public interface.
	public:
			__forceinline			InstrumentTrace(): dataLinked(false), data(0)		{}		// Public constructor.
			__forceinline			~InstrumentTrace()									{}		// Public destructor.

			__forceinline	void	Set(int i, void *_data, int size)	{ if (!dataLinked) LinkData(); if (data) memcpy((int*)data + i, _data, size);	}
			__forceinline	void	Set(int i, int val)					{ if (!dataLinked) LinkData(); if (data) ((int*)data)[i] = val;					}
			__forceinline	int		Get(int i)							{ if (!dataLinked) LinkData(); if (data) return ((int*)data)[i]; else return 0;	}

	#else

	public:
			__forceinline	void	Set(int i, void *data, int size)	{}
			__forceinline	void	Set(int i, int val)					{}
			__forceinline	int		Get(int i)							{ return 0; }
	#endif
	};

#endif // __ICEINSTRUMENTTRACE_H__
